/**
  ******************************************************************************
  * @file    py32f410_hal_msp.c
  * @author  MCU Application Team
  * @brief   This file provides code for the MSP Initialization
  *          and de-Initialization codes.
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2023 Puya Semiconductor Co.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by Puya under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2016 STMicroelectronics.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by ST under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */

/* Includes ------------------------------------------------------------------*/
#include "main.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* External functions --------------------------------------------------------*/

/**
  * @brief Initialize global MSP
  */
void HAL_MspInit(void)
{
  __HAL_RCC_SYSCFG_CLK_ENABLE();
  __HAL_RCC_PWR_CLK_ENABLE();
}

/**
  * @brief  Initialize RTC MSP
  * @param  hrtc：RTC handle
  * @retval None
  */
void HAL_RTC_MspInit(RTC_HandleTypeDef *hrtc)
{
  RCC_OscInitTypeDef        OscInitstruct = {0};
  RCC_PeriphCLKInitTypeDef  PeriphClkInitStruct = {0};

#ifdef RTC_CLOCK_SOURCE_LSE
  OscInitstruct.OscillatorType =  RCC_OSCILLATORTYPE_LSI | RCC_OSCILLATORTYPE_LSE;
  OscInitstruct.PLL.PLLState = RCC_PLL_NONE;
  OscInitstruct.LSEState = RCC_LSE_ON;
  OscInitstruct.LSEDriver = RCC_LSEDRIVE_MEDIUM;
  OscInitstruct.LSIState = RCC_LSI_OFF;
  if (HAL_RCC_OscConfig(&OscInitstruct) != HAL_OK)
  {
  }

  PeriphClkInitStruct.PeriphClockSelection = RCC_PERIPHCLK_RTC;
  PeriphClkInitStruct.RtcClockSelection = RCC_RTCCLKSOURCE_LSE;
  if (HAL_RCCEx_PeriphCLKConfig(&PeriphClkInitStruct) != HAL_OK)
  {
  }
#elif defined (RTC_CLOCK_SOURCE_LSI)
  /* Configure LSI as the clock source */
  OscInitstruct.OscillatorType =  RCC_OSCILLATORTYPE_LSI | RCC_OSCILLATORTYPE_LSE;
  OscInitstruct.PLL.PLLState = RCC_PLL_NONE;
  OscInitstruct.LSIState = RCC_LSI_ON;
  OscInitstruct.LSEState = RCC_LSE_OFF;
  /*OscInitstruct.LSEDriver = RCC_LSEDRIVE_MEDIUM;*/
  if (HAL_RCC_OscConfig(&OscInitstruct) != HAL_OK)
  {
  }
  
  /* Select LSI as the RTC clock source */
  PeriphClkInitStruct.PeriphClockSelection = RCC_PERIPHCLK_RTC;
  PeriphClkInitStruct.RtcClockSelection = RCC_RTCCLKSOURCE_LSI;
  if (HAL_RCCEx_PeriphCLKConfig(&PeriphClkInitStruct) != HAL_OK)
  {
  }
#else
#error Please select the RTC Clock source inside the main.h file
#endif /*RTC_CLOCK_SOURCE_LSE*/

  /*Enable RTC peripheral clock*/
  /* Enable RTC module */
  __HAL_RCC_RTC_ENABLE();

  /* Enable RTC interrupt */
  HAL_NVIC_SetPriority(TAMPER_IRQn, 0, 0);
  HAL_NVIC_EnableIRQ(TAMPER_IRQn);
}

/**
  * @brief  Deinitialize RTC MSP
  * @param  hrtc：RTC handle
  * @retval None
  */
void HAL_RTC_MspDeInit(RTC_HandleTypeDef *hrtc)
{
  __HAL_RCC_RTC_DISABLE();
}
/************************ (C) COPYRIGHT Puya *****END OF FILE******************/
